/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.newshader;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.blending.BufferBlendOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.image.ImageHolder;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.gl.uniform.LocationalUniformHolder;
import net.coderbot.iris.pipeline.PatchedShaderPrinter;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ExtendedShader;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.newshader.NewWorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.newshader.fallback.FallbackShader;
import net.coderbot.iris.pipeline.newshader.fallback.ShaderSynthesizer;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.TransformPatcher;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.loading.ProgramId;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.VanillaUniforms;
import net.coderbot.iris.uniforms.builtin.BuiltinReplacementUniforms;
import net.coderbot.iris.uniforms.custom.CustomUniforms;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_5912;

public class NewShaderTests {
    public static ExtendedShader create(WorldRenderingPipeline worldRenderingPipeline, String string, ProgramSource programSource, ProgramId programId, GlFramebuffer glFramebuffer, GlFramebuffer glFramebuffer2, GlFramebuffer glFramebuffer3, AlphaTest alphaTest, class_293 class_2932, ShaderAttributeInputs shaderAttributeInputs, FrameUpdateNotifier frameUpdateNotifier, NewWorldRenderingPipeline newWorldRenderingPipeline, Supplier<ImmutableSet<Integer>> supplier, FogMode fogMode, boolean bl, boolean bl2, boolean bl3, CustomUniforms customUniforms) throws IOException {
        AlphaTest alphaTest2 = programSource.getDirectives().getAlphaTestOverride().orElse(alphaTest);
        BlendModeOverride blendModeOverride = programSource.getDirectives().getBlendModeOverride().orElse(programId.getBlendModeOverride());
        Map<PatchShaderType, String> map = TransformPatcher.patchVanilla(programSource.getVertexSource().orElseThrow(RuntimeException::new), programSource.getGeometrySource().orElse(null), programSource.getFragmentSource().orElseThrow(RuntimeException::new), alphaTest2, true, shaderAttributeInputs, worldRenderingPipeline.getTextureMap());
        String string2 = map.get((Object)PatchShaderType.VERTEX);
        String string3 = map.get((Object)PatchShaderType.GEOMETRY);
        String string4 = map.get((Object)PatchShaderType.FRAGMENT);
        StringBuilder stringBuilder = new StringBuilder("{\n    \"blend\": {\n        \"func\": \"add\",\n        \"srcrgb\": \"srcalpha\",\n        \"dstrgb\": \"1-srcalpha\"\n    },\n    \"vertex\": \"" + string + "\",\n    \"fragment\": \"" + string + "\",\n    \"attributes\": [\n        \"Position\",\n        \"Color\",\n        \"UV0\",\n        \"UV1\",\n        \"UV2\",\n        \"Normal\"\n    ],\n    \"uniforms\": [\n        { \"name\": \"iris_TextureMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"iris_ModelViewMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"iris_ModelViewMatInverse\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"iris_ProjMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"iris_ProjMatInverse\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"iris_NormalMat\", \"type\": \"matrix3x3\", \"count\": 9, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0 ] },\n        { \"name\": \"iris_ChunkOffset\", \"type\": \"float\", \"count\": 3, \"values\": [ 0.0, 0.0, 0.0 ] },\n        { \"name\": \"iris_ColorModulator\", \"type\": \"float\", \"count\": 4, \"values\": [ 1.0, 1.0, 1.0, 1.0 ] },\n        { \"name\": \"iris_FogStart\", \"type\": \"float\", \"count\": 1, \"values\": [ 0.0 ] },\n        { \"name\": \"iris_FogEnd\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"iris_FogColor\", \"type\": \"float\", \"count\": 4, \"values\": [ 0.0, 0.0, 0.0, 0.0 ] }\n    ]\n}");
        String string5 = stringBuilder.toString();
        PatchedShaderPrinter.debugPatchedShaders(programSource.getName(), string2, string3, string4, string5);
        IrisProgramResourceFactory irisProgramResourceFactory = new IrisProgramResourceFactory(string5, string2, string3, string4);
        ArrayList<BufferBlendOverride> arrayList = new ArrayList<BufferBlendOverride>();
        programSource.getDirectives().getBufferBlendOverrides().forEach(bufferBlendInformation -> {
            int n = Ints.indexOf((int[])programSource.getDirectives().getDrawBuffers(), (int)bufferBlendInformation.getIndex());
            if (n > -1) {
                arrayList.add(new BufferBlendOverride(n, bufferBlendInformation.getBlendMode()));
            }
        });
        return new ExtendedShader(irisProgramResourceFactory, string, class_2932, glFramebuffer, glFramebuffer2, glFramebuffer3, blendModeOverride, alphaTest2, dynamicLocationalUniformHolder -> {
            CommonUniforms.addDynamicUniforms(dynamicLocationalUniformHolder, FogMode.PER_VERTEX);
            customUniforms.assignTo((LocationalUniformHolder)dynamicLocationalUniformHolder);
            BuiltinReplacementUniforms.addBuiltinReplacementUniforms(dynamicLocationalUniformHolder);
            VanillaUniforms.addVanillaUniforms(dynamicLocationalUniformHolder);
        }, (samplerHolder, imageHolder) -> newWorldRenderingPipeline.addGbufferOrShadowSamplers((SamplerHolder)samplerHolder, (ImageHolder)imageHolder, supplier, bl3, shaderAttributeInputs.toAvailability()), bl, newWorldRenderingPipeline, shaderAttributeInputs, arrayList, customUniforms);
    }

    public static FallbackShader createFallback(String string, GlFramebuffer glFramebuffer, GlFramebuffer glFramebuffer2, AlphaTest alphaTest, class_293 class_2932, BlendModeOverride blendModeOverride, NewWorldRenderingPipeline newWorldRenderingPipeline, FogMode fogMode, boolean bl, boolean bl2, boolean bl3) throws IOException {
        ShaderAttributeInputs shaderAttributeInputs = new ShaderAttributeInputs(class_2932, bl3);
        boolean bl4 = class_2932 == class_290.field_21468;
        String string2 = ShaderSynthesizer.vsh(true, shaderAttributeInputs, fogMode, bl, bl4);
        String string3 = ShaderSynthesizer.fsh(shaderAttributeInputs, fogMode, alphaTest, bl2, bl4);
        String string4 = "{\n    \"blend\": {\n        \"func\": \"add\",\n        \"srcrgb\": \"srcalpha\",\n        \"dstrgb\": \"1-srcalpha\"\n    },\n    \"vertex\": \"" + string + "\",\n    \"fragment\": \"" + string + "\",\n    \"attributes\": [\n        \"Position\",\n        \"Color\",\n" + (shaderAttributeInputs.hasTex() ? "        \"UV0\",\n" : "") + (shaderAttributeInputs.hasOverlay() ? "        \"UV1\",\n" : "") + (shaderAttributeInputs.hasLight() ? "        \"UV2\",\n" : "") + "        \"Normal\"\n    ],\n    \"uniforms\": [\n        { \"name\": \"TextureMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"ModelViewMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"ProjMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"ChunkOffset\", \"type\": \"float\", \"count\": 3, \"values\": [ 0.0, 0.0, 0.0 ] },\n        { \"name\": \"ColorModulator\", \"type\": \"float\", \"count\": 4, \"values\": [ 1.0, 1.0, 1.0, 1.0 ] },\n        { \"name\": \"Light0_Direction\", \"type\": \"float\", \"count\": 3, \"values\": [0.0, 0.0, 0.0] },\n        { \"name\": \"Light1_Direction\", \"type\": \"float\", \"count\": 3, \"values\": [0.0, 0.0, 0.0] },\n        { \"name\": \"FogStart\", \"type\": \"float\", \"count\": 1, \"values\": [ 0.0 ] },\n        { \"name\": \"FogEnd\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"FogDensity\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"FogIsExp2\", \"type\": \"int\", \"count\": 1, \"values\": [ 0 ] },\n        { \"name\": \"AlphaTestValue\", \"type\": \"float\", \"count\": 1, \"values\": [ 0.0 ] },\n        { \"name\": \"LineWidth\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"ScreenSize\", \"type\": \"float\", \"count\": 2, \"values\": [ 1.0, 1.0 ] },\n        { \"name\": \"FogColor\", \"type\": \"float\", \"count\": 4, \"values\": [ 0.0, 0.0, 0.0, 0.0 ] }\n    ]\n}";
        PatchedShaderPrinter.debugPatchedShaders(string, string2, null, string3, string4);
        IrisProgramResourceFactory irisProgramResourceFactory = new IrisProgramResourceFactory(string4, string2, null, string3);
        return new FallbackShader(irisProgramResourceFactory, string, class_2932, glFramebuffer, glFramebuffer2, blendModeOverride, alphaTest.getReference(), newWorldRenderingPipeline);
    }

    private static class IrisProgramResourceFactory
    implements class_5912 {
        private final String json;
        private final String vertex;
        private final String geometry;
        private final String fragment;

        public IrisProgramResourceFactory(String string, String string2, String string3, String string4) {
            this.json = string;
            this.vertex = string2;
            this.geometry = string3;
            this.fragment = string4;
        }

        public Optional<class_3298> method_14486(class_2960 class_29602) {
            String string = class_29602.method_12832();
            if (string.endsWith("json")) {
                return Optional.of(new StringResource(class_29602, this.json));
            }
            if (string.endsWith("vsh")) {
                return Optional.of(new StringResource(class_29602, this.vertex));
            }
            if (string.endsWith("gsh")) {
                if (this.geometry == null) {
                    return Optional.empty();
                }
                return Optional.of(new StringResource(class_29602, this.geometry));
            }
            if (string.endsWith("fsh")) {
                return Optional.of(new StringResource(class_29602, this.fragment));
            }
            return Optional.empty();
        }
    }

    private static class StringResource
    extends class_3298 {
        private final class_2960 id;
        private final String content;

        private StringResource(class_2960 class_29602, String string) {
            super("<iris shaderpack shaders>", () -> new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)));
            this.id = class_29602;
            this.content = string;
        }
    }
}

